var url = $('meta[name=url]').attr("content");

$('.alt-pagination').DataTable({
  "pagingType": "full_numbers",
  "language": {
    "url": url+"vendors/js/datatable-Persian.json"
  },
  "ajax": url+'ticket/list',
  "columns": [
    { "data": "1"},
    { "data": "2" },
    { "data": "3" },
    { "data": "4" },
    { "data": "5" },
    { "data": "6" },
  ],
  "scrollX": true,
  dom: "<'top'><'row'<'col-md-5 col-12'><'col-md-7 col-12'f>><'bottom'>rt<'row'<'col-md-5 col-12'i><'col-md-7 col-12'p>><'clear'>",
  "columnDefs": [
    {
      "targets": 0,
      "searchable": false,
      "orderable": true,
      "data": null,
      "render": function (data, type, full, meta) {
        return meta.settings._iDisplayStart + meta.row + 1;
      }
    }
  ],
  "displayLength": 15,
  "initComplete":function(){
    page = $('.alt-pagination').DataTable().page.info()['page'];
    if (page ==0 && $('.alt-pagination tr').length < 15) {
      $('.dataTables_paginate,.dataTables_info').hide();
    }else
      $('.dataTables_paginate,.dataTables_info').show();

  }
});

var tableselectionDelete = $('.alt-pagination').DataTable();
$('.selection-deletion-row tbody').on('click', 'tr', function () {
  if ($(this).hasClass('selected')) {
    $(this).removeClass('selected');
  } else {
    tableselectionDelete.$('tr.selected').removeClass('selected');
    $(this).addClass('selected');
  }
});


$(document).ready(function () {
  // bind 'myForm' and provide a simple callback function
  var bar = $('.progress-bar');
  var percent = $('.progress-bar');

  $('form').ajaxForm({
    beforeSend: function (xhr, opts) {
      if($('#file').val()!=""){
        var file = $('#file')[0].files[0];
        if(file.size>=5300000) {
          Swal.fire({
            type: 'warning',
            title: "خطا",
            html: 'حداکثر مجاز حجم فایل 5 مگابایت است.',
            confirmButtonText: "تایید",
          });
          xhr.abort();
          return false
        }
      }
      ElementBlock('form button');
      $('form').addClass('disable-block');

      if($('#file').val()!="")
        $('.progress').fadeIn();

      var percentVal = '0%';
      bar.css('width',percentVal+'%');
      percent.html(percentVal);
    },
    uploadProgress: function (event, position, total, percentComplete) {
      var percentVal = percentComplete-3 + '%';
      bar.width(percentVal);
      percent.html(percentVal);
    },
    complete: function (data) {
      bar.css('width','100%');
      percent.html(100);

      data = data.responseJSON;
      $('form').removeClass('disable-block');
      if (data.status == true) {
        Swal.fire({
          type: 'success',
          title: "انجام شد",
          html: data.message,
          confirmButtonText: "تایید",
          didClose: () => {
            location.href= url +"ticket/"+data.id;
          }
        });
      } else {
        Swal.fire({
          type: 'error',
          title: "خطا",
          html: data.message,
          confirmButtonText: "تایید",
        })
        $('.progress').fadeOut();
      }
        ElementUnBlock('form button');
    }
  });
});
